/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Locale;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class DNSName
implements GeneralNameInterface {
    private String name;
    private static final String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String digitsAndHyphen = "0123456789-";
    private static final String alphaDigitsAndHyphen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";

    public DNSName(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
    }

    public DNSName(String string) throws IOException {
        this(string, false);
    }

    public DNSName(String string, boolean bl) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("DNS name must not be null");
        }
        if (string.indexOf(32) != -1) {
            throw new IOException("DNS names or NameConstraints with blank components are not permitted");
        }
        if (string.charAt(0) == '.' || string.charAt(string.length() - 1) == '.') {
            throw new IOException("DNS names or NameConstraints may not begin or end with a .");
        }
        int n = 0;
        while (n < string.length()) {
            int n2;
            int n3 = string.indexOf(46, n);
            if (n3 < 0) {
                n3 = string.length();
            }
            if (n3 - n < 1) {
                throw new IOException("DNSName SubjectAltNames with empty components are not permitted");
            }
            if (!bl) {
                if (alpha.indexOf(string.charAt(n)) < 0) {
                    throw new IOException("DNSName components must begin with a letter");
                }
            } else {
                n2 = string.charAt(n);
                if (alpha.indexOf(n2) < 0 && !Character.isDigit((char)n2)) {
                    throw new IOException("DNSName components must begin with a letter or digit");
                }
            }
            for (n2 = n + 1; n2 < n3; ++n2) {
                char c = string.charAt(n2);
                if (alphaDigitsAndHyphen.indexOf(c) >= 0) continue;
                throw new IOException("DNSName components must consist of letters, digits, and hyphens");
            }
            n = n3 + 1;
        }
        this.name = string;
    }

    @Override
    public int getType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.name);
    }

    public String toString() {
        return "DNSName: " + this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DNSName)) {
            return false;
        }
        DNSName dNSName = (DNSName)object;
        return this.name.equalsIgnoreCase(dNSName.name);
    }

    public int hashCode() {
        return this.name.toUpperCase(Locale.ENGLISH).hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        int n2;
        String string;
        String string2;
        int n3 = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 2 ? -1 : ((string2 = ((DNSName)generalNameInterface).getName().toLowerCase(Locale.ENGLISH)).equals(string = this.name.toLowerCase(Locale.ENGLISH)) ? 0 : (string.endsWith(string2) ? (string.charAt((n2 = string.lastIndexOf(string2)) - 1) == '.' ? 2 : 3) : (string2.endsWith(string) ? (string2.charAt((n = string2.lastIndexOf(string)) - 1) == '.' ? 1 : 3) : 3))));
        return n3;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        int n = 1;
        int n2 = this.name.indexOf(46);
        while (n2 >= 0) {
            ++n;
            n2 = this.name.indexOf(46, n2 + 1);
        }
        return n;
    }
}

